/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls;

import com.floragunn.codova.config.templates.AttributeSource;
import com.floragunn.codova.config.templates.ExpressionEvaluationException;
import com.floragunn.codova.config.templates.Template;
import com.floragunn.codova.config.text.Pattern;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.PrivilegesEvaluationException;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.enterprise.dlsfls.DlsRestriction;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import com.floragunn.searchsupport.cstate.metrics.Measurement;
import com.floragunn.searchsupport.cstate.metrics.Meter;
import com.floragunn.searchsupport.cstate.metrics.MetricsLevel;
import com.floragunn.searchsupport.cstate.metrics.TimeAggregation;
import com.floragunn.searchsupport.queries.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RoleBasedDocumentAuthorization
implements ComponentStateProvider {
    private static final Logger log = LogManager.getLogger(RoleBasedDocumentAuthorization.class);
    private final SgDynamicConfiguration<Role> roles;
    private final StaticIndexQueries staticIndexQueries;
    private volatile StatefulIndexQueries statefulIndexQueries;
    private final ComponentState componentState = new ComponentState("role_based_document_authorization");
    private final MetricsLevel metricsLevel;
    private final TimeAggregation statefulIndexRebuild = new TimeAggregation.Milliseconds();

    public RoleBasedDocumentAuthorization(SgDynamicConfiguration<Role> roles, Set<String> indices, MetricsLevel metricsLevel) {
        this.roles = roles;
        this.metricsLevel = metricsLevel;
        this.staticIndexQueries = new StaticIndexQueries(roles);
        try (Meter meter = Meter.basic((MetricsLevel)metricsLevel, (TimeAggregation)this.statefulIndexRebuild);){
            this.statefulIndexQueries = new StatefulIndexQueries(roles, indices);
        }
        this.componentState.addPart(this.staticIndexQueries.getComponentState());
        this.componentState.addPart(this.statefulIndexQueries.getComponentState());
        this.componentState.setConfigVersion(roles.getDocVersion());
        this.componentState.updateStateFromParts();
        if (metricsLevel.basicEnabled()) {
            this.componentState.addMetrics("stateful_index_rebuilds", (Measurement)this.statefulIndexRebuild);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    boolean hasDlsRestrictions(PrivilegesEvaluationContext context, Collection<String> indices, Meter meter) throws PrivilegesEvaluationException {
        try (Meter subMeter = meter.detail("has_dls_restriction");){
            if (this.staticIndexQueries.rolesWithIndexWildcardWithoutQuery.containsAny((Collection)context.getMappedRoles())) {
                boolean bl = false;
                return bl;
            }
            StatefulIndexQueries statefulIndexQueries = this.statefulIndexQueries;
            if (!statefulIndexQueries.indices.containsAll(indices)) {
                if (log.isDebugEnabled()) {
                    log.debug("Indices {} do not exist. Assuming full document restriction.", indices);
                }
                boolean bl = true;
                return bl;
            }
            for (String index : indices) {
                ImmutableSet roleWithoutQuery = (ImmutableSet)statefulIndexQueries.indexToRoleWithoutQuery.get((Object)index);
                if (roleWithoutQuery != null && roleWithoutQuery.containsAny((Collection)context.getMappedRoles())) continue;
                ImmutableMap roleToQuery = (ImmutableMap)this.statefulIndexQueries.indexToRoleToQuery.get((Object)index);
                for (String role : context.getMappedRoles()) {
                    DlsQuery query = (DlsQuery)this.staticIndexQueries.roleWithIndexWildcardToQuery.get((Object)role);
                    if (query != null) {
                        boolean bl = true;
                        return bl;
                    }
                    if (roleToQuery != null && (query = (DlsQuery)roleToQuery.get((Object)role)) != null) {
                        boolean bl = true;
                        return bl;
                    }
                    ImmutableMap indexPatternTemplateToQuery = (ImmutableMap)this.staticIndexQueries.rolesToIndexPatternTemplateToQuery.get((Object)role);
                    if (indexPatternTemplateToQuery == null) continue;
                    for (Map.Entry entry : indexPatternTemplateToQuery.entrySet()) {
                        try {
                            Pattern pattern = context.getRenderedPattern(((Role.IndexPatterns.IndexPatternTemplate)entry.getKey()).getTemplate());
                            if (!pattern.matches(index) || ((Role.IndexPatterns.IndexPatternTemplate)entry.getKey()).getExclusions().matches(index)) continue;
                            boolean bl = true;
                            return bl;
                        }
                        catch (ExpressionEvaluationException e) {
                            throw new PrivilegesEvaluationException("Error while rendering index pattern of role " + role, (Throwable)e);
                        }
                    }
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (PrivilegesEvaluationException e) {
            this.componentState.addLastException("has_dls_restriction", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            this.componentState.addLastException("has_dls_restriction_u", (Throwable)e);
            throw e;
        }
    }

    public DlsRestriction getDlsRestriction(PrivilegesEvaluationContext context, String index, Meter meter) throws PrivilegesEvaluationException {
        DlsRestriction dlsRestriction;
        block9: {
            Meter subMeter = meter.detail("evaluate_dls");
            try {
                dlsRestriction = this.getDlsRestrictionInternal(context, index);
                if (subMeter == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (subMeter != null) {
                        try {
                            subMeter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (PrivilegesEvaluationException e) {
                    this.componentState.addLastException("get_dls_restriction", (Throwable)e);
                    throw e;
                }
                catch (RuntimeException e) {
                    this.componentState.addLastException("get_dls_restriction_u", (Throwable)e);
                    throw e;
                }
            }
            subMeter.close();
        }
        return dlsRestriction;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DlsRestriction.IndexMap getDlsRestriction(PrivilegesEvaluationContext context, Collection<String> indices, Meter meter) throws PrivilegesEvaluationException {
        try (Meter subMeter = meter.detail("evaluate_dls");){
            Object object;
            if (this.staticIndexQueries.rolesWithIndexWildcardWithoutQuery.containsAny((Collection)context.getMappedRoles())) {
                DlsRestriction.IndexMap indexMap = DlsRestriction.IndexMap.NONE;
                return indexMap;
            }
            ImmutableMap.Builder result = new ImmutableMap.Builder(indices.size());
            int restrictedIndices = 0;
            for (String index : indices) {
                DlsRestriction restriction = this.getDlsRestrictionInternal(context, index);
                if (!restriction.isUnrestricted()) {
                    ++restrictedIndices;
                }
                result.put((Object)index, (Object)restriction);
            }
            if (restrictedIndices == 0) {
                object = DlsRestriction.IndexMap.NONE;
                return object;
            }
            object = new DlsRestriction.IndexMap((ImmutableMap<String, DlsRestriction>)result.build());
            return object;
        }
        catch (PrivilegesEvaluationException e) {
            this.componentState.addLastException("get_dls_restriction", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            this.componentState.addLastException("get_dls_restriction_u", (Throwable)e);
            throw e;
        }
    }

    private DlsRestriction getDlsRestrictionInternal(PrivilegesEvaluationContext context, String index) throws PrivilegesEvaluationException {
        if (this.staticIndexQueries.rolesWithIndexWildcardWithoutQuery.containsAny((Collection)context.getMappedRoles())) {
            return DlsRestriction.NONE;
        }
        StatefulIndexQueries statefulIndexQueries = this.statefulIndexQueries;
        if (!statefulIndexQueries.indices.contains((Object)index)) {
            if (log.isDebugEnabled()) {
                log.debug("Index {} does not exist. Assuming full document restriction.", (Object)index);
            }
            return DlsRestriction.FULL;
        }
        ImmutableSet roleWithoutQuery = (ImmutableSet)statefulIndexQueries.indexToRoleWithoutQuery.get((Object)index);
        if (roleWithoutQuery != null && roleWithoutQuery.containsAny((Collection)context.getMappedRoles())) {
            return DlsRestriction.NONE;
        }
        ImmutableMap roleToQuery = (ImmutableMap)this.statefulIndexQueries.indexToRoleToQuery.get((Object)index);
        HashSet<DlsQuery> queries = new HashSet<DlsQuery>();
        for (String role : context.getMappedRoles()) {
            ImmutableMap indexPatternTemplateToQuery;
            DlsQuery query = (DlsQuery)this.staticIndexQueries.roleWithIndexWildcardToQuery.get((Object)role);
            if (query != null) {
                queries.add(query);
            }
            if (roleToQuery != null && (query = (DlsQuery)roleToQuery.get((Object)role)) != null) {
                queries.add(query);
            }
            if ((indexPatternTemplateToQuery = (ImmutableMap)this.staticIndexQueries.rolesToIndexPatternTemplateToQuery.get((Object)role)) == null) continue;
            for (Map.Entry entry : indexPatternTemplateToQuery.entrySet()) {
                try {
                    Pattern pattern = context.getRenderedPattern(((Role.IndexPatterns.IndexPatternTemplate)entry.getKey()).getTemplate());
                    if (!pattern.matches(index) || ((Role.IndexPatterns.IndexPatternTemplate)entry.getKey()).getExclusions().matches(index)) continue;
                    queries.add((DlsQuery)entry.getValue());
                }
                catch (ExpressionEvaluationException e) {
                    throw new PrivilegesEvaluationException("Error while rendering index pattern of role " + role, (Throwable)e);
                }
            }
        }
        if (queries.isEmpty()) {
            return DlsRestriction.NONE;
        }
        ArrayList<Query> renderedQueries = new ArrayList<Query>(queries.size());
        for (DlsQuery query : queries) {
            try {
                renderedQueries.add((Query)query.queryTemplate.render((AttributeSource)context.getUser()));
            }
            catch (ExpressionEvaluationException e) {
                throw new PrivilegesEvaluationException("Error while rendering query " + query, (Throwable)e);
            }
        }
        return new DlsRestriction((ImmutableList<Query>)ImmutableList.of(renderedQueries));
    }

    public synchronized void updateIndices(Set<String> indices) {
        StatefulIndexQueries statefulIndexQueries = this.statefulIndexQueries;
        if (!statefulIndexQueries.indices.equals(indices)) {
            try (Meter meter = Meter.basic((MetricsLevel)this.metricsLevel, (TimeAggregation)this.statefulIndexRebuild);){
                this.statefulIndexQueries = new StatefulIndexQueries(this.roles, indices);
                this.componentState.replacePart(this.statefulIndexQueries.getComponentState());
            }
        }
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }

    static class DlsQuery {
        final Template<Query> queryTemplate;

        DlsQuery(Template<Query> queryTemplate) {
            this.queryTemplate = queryTemplate;
        }

        public int hashCode() {
            return this.queryTemplate.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DlsQuery)) {
                return false;
            }
            DlsQuery other = (DlsQuery)obj;
            return !(this.queryTemplate == null ? other.queryTemplate != null : !this.queryTemplate.equals(other.queryTemplate));
        }
    }

    static class StatefulIndexQueries
    implements ComponentStateProvider {
        private final ImmutableMap<String, ImmutableMap<String, DlsQuery>> indexToRoleToQuery;
        private final ImmutableMap<String, ImmutableSet<String>> indexToRoleWithoutQuery;
        private final ImmutableSet<String> indices;
        private final ImmutableMap<String, ImmutableList<Exception>> rolesToInitializationErrors;
        private final ComponentState componentState;

        StatefulIndexQueries(SgDynamicConfiguration<Role> roles, Set<String> indices) {
            this.indices = ImmutableSet.of(indices);
            this.componentState = new ComponentState("stateful_index_queries");
            ImmutableMap.Builder indexToRoleToQuery = new ImmutableMap.Builder().defaultValue(k -> new ImmutableMap.Builder());
            ImmutableMap.Builder indexToRoleWithoutQuery = new ImmutableMap.Builder().defaultValue(k -> new ImmutableSet.Builder());
            ImmutableMap.Builder rolesToInitializationErrors = new ImmutableMap.Builder().defaultValue(k -> new ImmutableList.Builder());
            for (Map.Entry entry : roles.getCEntries().entrySet()) {
                try {
                    String roleName = (String)entry.getKey();
                    Role role = (Role)entry.getValue();
                    for (Role.Index indexPermissions : role.getIndexPermissions()) {
                        if (indexPermissions.getIndexPatterns().getPattern().isWildcard() || indexPermissions.getIndexPatterns().getPattern().isBlank()) continue;
                        Pattern indexPattern = indexPermissions.getIndexPatterns().getPattern();
                        Template dlsQueryTemplate = indexPermissions.getDls();
                        if (dlsQueryTemplate != null) {
                            DlsQuery dlsConfig = new DlsQuery((Template<Query>)dlsQueryTemplate);
                            for (String index : indexPattern.iterateMatching(indices)) {
                                ((ImmutableMap.Builder)indexToRoleToQuery.get((Object)index)).put((Object)roleName, (Object)dlsConfig);
                            }
                            continue;
                        }
                        for (String index : indexPattern.iterateMatching(indices)) {
                            ((ImmutableSet.Builder)indexToRoleWithoutQuery.get((Object)index)).add((Object)roleName);
                        }
                    }
                }
                catch (Exception e) {
                    log.error("Unexpected exception while processing role: " + entry + "\nIgnoring role.", (Throwable)e);
                    ((ImmutableList.Builder)rolesToInitializationErrors.get((Object)((String)entry.getKey()))).with((Object)e);
                }
            }
            this.indexToRoleToQuery = indexToRoleToQuery.build(b -> b.build());
            this.indexToRoleWithoutQuery = indexToRoleWithoutQuery.build(b -> b.build());
            this.rolesToInitializationErrors = rolesToInitializationErrors.build(b -> b.build());
            if (this.rolesToInitializationErrors.isEmpty()) {
                this.componentState.initialized();
            } else {
                this.componentState.setState(ComponentState.State.PARTIALLY_INITIALIZED, "roles_with_errors");
                this.componentState.addDetail((Object)rolesToInitializationErrors);
            }
        }

        public ComponentState getComponentState() {
            return this.componentState;
        }
    }

    static class StaticIndexQueries
    implements ComponentStateProvider {
        private final ComponentState componentState = new ComponentState("static_index_queries");
        private final ImmutableSet<String> rolesWithIndexWildcardWithoutQuery;
        private final ImmutableMap<String, DlsQuery> roleWithIndexWildcardToQuery;
        private final ImmutableMap<String, ImmutableMap<Role.IndexPatterns.IndexPatternTemplate, DlsQuery>> rolesToIndexPatternTemplateToQuery;
        private final ImmutableMap<String, ImmutableList<Exception>> rolesToInitializationErrors;

        StaticIndexQueries(SgDynamicConfiguration<Role> roles) {
            ImmutableSet.Builder rolesWithIndexWildcardWithoutQuery = new ImmutableSet.Builder();
            ImmutableMap.Builder roleWithIndexWildcardToQuery = new ImmutableMap.Builder();
            ImmutableMap.Builder rolesToIndexPatternTemplateToQuery = new ImmutableMap.Builder().defaultValue(k -> new ImmutableMap.Builder());
            ImmutableMap.Builder rolesToInitializationErrors = new ImmutableMap.Builder().defaultValue(k -> new ImmutableList.Builder());
            for (Map.Entry entry : roles.getCEntries().entrySet()) {
                try {
                    String roleName = (String)entry.getKey();
                    Role role = (Role)entry.getValue();
                    for (Role.Index indexPermissions : role.getIndexPermissions()) {
                        if (indexPermissions.getIndexPatterns().getPattern().isWildcard()) {
                            Template dlsQueryTemplate = indexPermissions.getDls();
                            if (dlsQueryTemplate == null) {
                                rolesWithIndexWildcardWithoutQuery.add((Object)roleName);
                                continue;
                            }
                            DlsQuery dlsConfig = new DlsQuery((Template<Query>)dlsQueryTemplate);
                            roleWithIndexWildcardToQuery.put((Object)roleName, (Object)dlsConfig);
                            continue;
                        }
                        for (Role.IndexPatterns.IndexPatternTemplate indexPatternTemplate : indexPermissions.getIndexPatterns().getPatternTemplates()) {
                            Template dlsQueryTemplate = indexPermissions.getDls();
                            if (dlsQueryTemplate == null) continue;
                            DlsQuery dlsConfig = new DlsQuery((Template<Query>)dlsQueryTemplate);
                            ((ImmutableMap.Builder)rolesToIndexPatternTemplateToQuery.get((Object)roleName)).put((Object)indexPatternTemplate, (Object)dlsConfig);
                        }
                    }
                }
                catch (Exception e) {
                    log.error("Unexpected exception while processing role: " + entry + "\nIgnoring role.", (Throwable)e);
                    ((ImmutableList.Builder)rolesToInitializationErrors.get((Object)((String)entry.getKey()))).with((Object)e);
                }
            }
            this.rolesWithIndexWildcardWithoutQuery = rolesWithIndexWildcardWithoutQuery.build();
            this.roleWithIndexWildcardToQuery = roleWithIndexWildcardToQuery.build();
            this.rolesToIndexPatternTemplateToQuery = rolesToIndexPatternTemplateToQuery.build(b -> b.build());
            this.rolesToInitializationErrors = rolesToInitializationErrors.build(b -> b.build());
            if (this.rolesToInitializationErrors.isEmpty()) {
                this.componentState.initialized();
            } else {
                this.componentState.setState(ComponentState.State.PARTIALLY_INITIALIZED, "roles_with_errors");
                this.componentState.addDetail((Object)rolesToInitializationErrors);
            }
        }

        public ComponentState getComponentState() {
            return this.componentState;
        }
    }
}

